/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.particle;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.redpxnda.respawnobelisks.registry.particle.RuneCircleType;
import com.redpxnda.respawnobelisks.util.ClientUtils;
import com.redpxnda.respawnobelisks.util.RenderUtils;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class RuneCircleParticle
extends Particle {
    private final SpriteSet set;
    private final Vector3f[] colors = new Vector3f[2];
    private final float scale;

    protected RuneCircleParticle(int age, int lifetime, float scale, Vector3f primCol, Vector3f secCol, ClientLevel clientLevel, SpriteSet set, double d, double e, double f) {
        super(clientLevel, d, e, f);
        this.setAge(age);
        this.f_107225_ = lifetime;
        this.set = set;
        this.m_107250_(1.0f, 1.0f);
        this.f_107219_ = false;
        this.colors[0] = primCol;
        this.colors[1] = secCol;
        this.scale = scale;
        ClientUtils.activeRuneParticles.put((List<Double>)ImmutableList.of((Object)d, (Object)e, (Object)f), this);
    }

    public void setAge(int newAge) {
        this.f_107224_ = newAge;
    }

    public int getAge() {
        return this.f_107224_;
    }

    public double getX() {
        return this.f_107212_;
    }

    public double getY() {
        return this.f_107213_;
    }

    public double getZ() {
        return this.f_107214_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 vec3 = camera.m_90583_();
        float g = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
        float h = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
        float i = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
        Vector3f[] vector3fs = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float alpha = 1.0f;
        float life = this.f_107225_;
        if ((float)this.f_107224_ / life >= 0.8f) {
            alpha = (float)((double)alpha * ((double)(life - (float)this.f_107224_) / ((double)life - (double)life * 0.8)));
        }
        RenderUtils.renderRuneCircle(this.f_107208_.m_46467_(), this.scale, this.colors, alpha, g, h, i, this.set, vector3fs, vertexConsumer, 0xF000F0);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<RuneCircleType.Options> {
        SpriteSet set;

        public Provider(SpriteSet spriteSet) {
            this.set = spriteSet;
        }

        @Nullable
        public Particle createParticle(RuneCircleType.Options options, ClientLevel clientLevel, double d, double e, double f, double g, double h, double i) {
            return new RuneCircleParticle(options.time(), options.maxTime(), options.scale(), options.primary(), options.secondary(), clientLevel, this.set, d, e, f);
        }
    }
}

